package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import com.agilex.healthcare.veteranappointment.datalayer.PersistenceObject;
import com.agilex.healthcare.veteranappointment.datalayer.Transformable;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequestDetailCode;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name = "AR_DETAIL_CODE")
@XStreamAlias("AppointmentRequestDetailCode")
public class AppointmentRequestDetailCodePo extends PersistenceObject implements Transformable<VARAppointmentRequestDetailCode> {

	private static final long serialVersionUID = 4349985670679093473L;
	
	private String appointmentRequestDetailCodeId;
	private Date createdDate;
	
	private AppointmentRequestPo appointmentRequest;
	private DetailCodePo detailCode;

	public AppointmentRequestDetailCodePo() {
	}
	
	public AppointmentRequestDetailCodePo(VARAppointmentRequestDetailCode dto) {
		setAppointmentRequestDetailCodeId(dto.getAppointmentRequestDetailCodeId());
		setCreatedDate(dto.getCreatedDate());
		setDetailCode(new DetailCodePo(dto.getDetailCode()));
		setUserId(dto.getUserId());
	}

	@Id
	@GeneratedValue(generator="ardc_id_generator")
	@GenericGenerator(name="ardc_id_generator", strategy = "uuid")
	@Column(name = "AR_DETAIL_CODE_ID")
	public String getAppointmentRequestDetailCodeId() {
		return appointmentRequestDetailCodeId;
	}

	public void setAppointmentRequestDetailCodeId(String appointmentRequestDetailCodeId) {
		this.appointmentRequestDetailCodeId = appointmentRequestDetailCodeId;
	}

	@ManyToOne(targetEntity = AppointmentRequestPo.class, optional = false)
	@JoinColumn(name = "APPOINTMENT_REQUEST_ID")
	public AppointmentRequestPo getAppointmentRequest() {
		return appointmentRequest;
	}

	public void setAppointmentRequest(AppointmentRequestPo appointmentRequest) {
		this.appointmentRequest = appointmentRequest;
	}

	@ManyToOne(targetEntity = DetailCodePo.class, optional = false, fetch = FetchType.EAGER)
	@JoinColumn(name="DETAIL_CODE_ID")
	public DetailCodePo getDetailCode() {
		return detailCode;
	}

	public void setDetailCode(DetailCodePo detailCode) {
		this.detailCode = detailCode;
	}

	@Column(name = "CREATED_DATE")
	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	@Column(name = "USER_ID")
	@Override
	public String getUserId() {
		return super.getUserId();
	}

	@Override
	public VARAppointmentRequestDetailCode create() {
        VARAppointmentRequestDetailCode dto = new VARAppointmentRequestDetailCode();
		
		dto.setAppointmentRequestDetailCodeId(getAppointmentRequestDetailCodeId());
		dto.setCreatedDate(getCreatedDate());
		dto.setDetailCode(getDetailCode().create());
		dto.setUserId(getUserId());
		
		return dto;
	}
}
